/// InitializeGame()

// Are we debugging?
global.debug = true;

// key mappings
global.keyJump  = vk_up;
global.keyRight = vk_right;
global.keyLeft  = vk_left;
global.keyShoot = vk_space;

global.keyMenu  = vk_enter;
global.keyExit  = vk_escape;
global.keyReset = vk_f5;
global.keyDebug = vk_f2;

// Game settings

global.resolutionWidth  = 1920;
global.resolutionHeight = 1080;
global.fullscreen   = false;
global.soundVolume  = 1;
global.musicVolume  = 1;
global.masterVolume = 1;

// Layers
global.mainLayer		= "Instances";
global.collisionLayer	= "Collision";
global.controllersLayer = "Controllers";
global.bulletsLayer		= "Bullets";
global.activeObjectsLayer = "ActiveObjects";
global.backgroundObjectsLayer = "BackgroundObjects";

/// @description Initialize Room

Log("==============================");
Log("mainLayer ID"		  + string(global.mainLayer));
Log("collisionLayer ID"   + string(global.collisionLayer));
Log("controllersLayer ID" + string(global.controllersLayer));
Log("bulletsLayer ID"	  + string(global.bulletsLayer));
Log("activeObjectsLayer ID"	  + string(global.activeObjectsLayer));
Log("backgroundObjectsLayer ID"	  + string(global.backgroundObjectsLayer));

camera		= instance_create_layer(room_width / 2, room_height /2, global.controllersLayer, oCameraController);
GUI			= instance_create_layer(0, 0, global.controllersLayer, oGUI);
sndManager	= instance_create_layer(0, 0, global.controllersLayer, oSoundManager);

state = gameState.playing;

roomName = "";